package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface ImageSourceFluent<A extends ImageSourceFluent<A>> extends Fluent<A>{


    public ObjectReference getFrom();    public A withFrom( ObjectReference from);    public FromNested<A> withNewFrom();    public FromNested<A> withNewFromLike( ObjectReference item);    public FromNested<A> editFrom();    public A addToPaths( ImageSourcePath ...items);    public A removeFromPaths( ImageSourcePath ...items);    public List<ImageSourcePath> getPaths();    public A withPaths( List<ImageSourcePath> paths);    public A withPaths( ImageSourcePath ...paths);    public PathsNested<A> addNewPath();    public PathsNested<A> addNewPathLike( ImageSourcePath item);    public A addNewPath( String destinationDir,  String sourcePath);    public LocalObjectReference getPullSecret();    public A withPullSecret( LocalObjectReference pullSecret);    public PullSecretNested<A> withNewPullSecret();    public PullSecretNested<A> withNewPullSecretLike( LocalObjectReference item);    public PullSecretNested<A> editPullSecret();    public A withNewPullSecret( String name);
    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<FromNested<N>>{
            public N endFrom();            public N and();        
}

    public interface PathsNested<N> extends Nested<N>,ImageSourcePathFluent<PathsNested<N>>{
            public N and();            public N endPath();        
}

    public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<PullSecretNested<N>>{
            public N and();            public N endPullSecret();        
}


}
