package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public class ImageSourceFluentImpl<A extends ImageSourceFluent<A>> extends BaseFluent<A> implements ImageSourceFluent<A>{

     VisitableBuilder<ObjectReference, ?> from;     List<VisitableBuilder<ImageSourcePath, ?>> paths = new ArrayList();     VisitableBuilder<LocalObjectReference, ?> pullSecret;
public ImageSourceFluentImpl(){
    
}
public ImageSourceFluentImpl( ImageSource instance ){
    this.withFrom(instance.getFrom()); this.withPaths(instance.getPaths()); this.withPullSecret(instance.getPullSecret()); 
}

    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public A withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }
    public FromNested<A> withNewFrom(){
    return new FromNestedImpl();
    }
    public FromNested<A> withNewFromLike( ObjectReference item){
    return new FromNestedImpl(item);
    }
    public FromNested<A> editFrom(){
    return withNewFromLike(getFrom());
    }
    public A addToPaths( ImageSourcePath ...items){
    for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.add(builder);this.paths.add(builder);} return (A)this;
    }
    public A removeFromPaths( ImageSourcePath ...items){
    for (ImageSourcePath item : items) {ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);_visitables.remove(builder);this.paths.remove(builder);} return (A)this;
    }
    public List<ImageSourcePath> getPaths(){
    return build(paths);
    }
    public A withPaths( List<ImageSourcePath> paths){
    this.paths.clear();if (paths != null) {for (ImageSourcePath item : paths){this.addToPaths(item);}} return (A) this;
    }
    public A withPaths( ImageSourcePath ...paths){
    this.paths.clear(); if (paths != null) {for (ImageSourcePath item :paths){ this.addToPaths(item);}} return (A) this;
    }
    public PathsNested<A> addNewPath(){
    return new PathsNestedImpl();
    }
    public PathsNested<A> addNewPathLike( ImageSourcePath item){
    return new PathsNestedImpl(item);
    }
    public A addNewPath( String destinationDir,  String sourcePath){
    return addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }
    public LocalObjectReference getPullSecret(){
    return this.pullSecret!=null?this.pullSecret.build():null;
    }
    public A withPullSecret( LocalObjectReference pullSecret){
    if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.add(this.pullSecret);} return (A) this;
    }
    public PullSecretNested<A> withNewPullSecret(){
    return new PullSecretNestedImpl();
    }
    public PullSecretNested<A> withNewPullSecretLike( LocalObjectReference item){
    return new PullSecretNestedImpl(item);
    }
    public PullSecretNested<A> editPullSecret(){
    return withNewPullSecretLike(getPullSecret());
    }
    public A withNewPullSecret( String name){
    return withPullSecret(new LocalObjectReference(name));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageSourceFluentImpl that = (ImageSourceFluentImpl) o;
if (from != null ? !from.equals(that.from) :that.from != null) return false;
if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
return true;

    }

    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<FromNested<N>> implements FromNested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             FromNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) ImageSourceFluentImpl.this.withFrom(builder.build());
        }
    
}
    public class PathsNestedImpl<N> extends ImageSourcePathFluentImpl<PathsNested<N>> implements PathsNested<N>{

        private final ImageSourcePathBuilder builder;
    
             PathsNestedImpl (){
        this.builder = new ImageSourcePathBuilder(this);
        }
             PathsNestedImpl ( ImageSourcePath item){
        this.builder = new ImageSourcePathBuilder(this, item);
        }
    
            public N and(){
            return (N) ImageSourceFluentImpl.this.addToPaths(builder.build());
        }
            public N endPath(){
            return and();
        }
    
}
    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<PullSecretNested<N>> implements PullSecretNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             PullSecretNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             PullSecretNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) ImageSourceFluentImpl.this.withPullSecret(builder.build());
        }
            public N endPullSecret(){
            return and();
        }
    
}


}
