package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class ImageStreamSpecFluentImpl<A extends ImageStreamSpecFluent<A>> extends BaseFluent<A> implements ImageStreamSpecFluent<A>{

     String dockerImageRepository;     List<VisitableBuilder<TagReference, ?>> tags = new ArrayList();
public ImageStreamSpecFluentImpl(){
    
}
public ImageStreamSpecFluentImpl( ImageStreamSpec instance ){
    this.withDockerImageRepository(instance.getDockerImageRepository()); this.withTags(instance.getTags()); 
}

    public String getDockerImageRepository(){
    return this.dockerImageRepository;
    }
    public A withDockerImageRepository( String dockerImageRepository){
    this.dockerImageRepository=dockerImageRepository; return (A) this;
    }
    public A addToTags( TagReference ...items){
    for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.add(builder);this.tags.add(builder);} return (A)this;
    }
    public A removeFromTags( TagReference ...items){
    for (TagReference item : items) {TagReferenceBuilder builder = new TagReferenceBuilder(item);_visitables.remove(builder);this.tags.remove(builder);} return (A)this;
    }
    public List<TagReference> getTags(){
    return build(tags);
    }
    public A withTags( List<TagReference> tags){
    this.tags.clear();if (tags != null) {for (TagReference item : tags){this.addToTags(item);}} return (A) this;
    }
    public A withTags( TagReference ...tags){
    this.tags.clear(); if (tags != null) {for (TagReference item :tags){ this.addToTags(item);}} return (A) this;
    }
    public TagsNested<A> addNewTag(){
    return new TagsNestedImpl();
    }
    public TagsNested<A> addNewTagLike( TagReference item){
    return new TagsNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageStreamSpecFluentImpl that = (ImageStreamSpecFluentImpl) o;
if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
return true;

    }

    public class TagsNestedImpl<N> extends TagReferenceFluentImpl<TagsNested<N>> implements TagsNested<N>{

        private final TagReferenceBuilder builder;
    
             TagsNestedImpl (){
        this.builder = new TagReferenceBuilder(this);
        }
             TagsNestedImpl ( TagReference item){
        this.builder = new TagReferenceBuilder(this, item);
        }
    
            public N endTag(){
            return and();
        }
            public N and(){
            return (N) ImageStreamSpecFluentImpl.this.addToTags(builder.build());
        }
    
}


}
