package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedClusterRoleBindingFluentImpl<A extends NamedClusterRoleBindingFluent<A>> extends BaseFluent<A> implements NamedClusterRoleBindingFluent<A>{

     String name;     VisitableBuilder<ClusterRoleBinding, ?> roleBinding;
public NamedClusterRoleBindingFluentImpl(){
    
}
public NamedClusterRoleBindingFluentImpl( NamedClusterRoleBinding instance ){
    this.withName(instance.getName()); this.withRoleBinding(instance.getRoleBinding()); 
}

    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public ClusterRoleBinding getRoleBinding(){
    return this.roleBinding!=null?this.roleBinding.build():null;
    }
    public A withRoleBinding( ClusterRoleBinding roleBinding){
    if (roleBinding!=null){ this.roleBinding= new ClusterRoleBindingBuilder(roleBinding); _visitables.add(this.roleBinding);} return (A) this;
    }
    public RoleBindingNested<A> withNewRoleBinding(){
    return new RoleBindingNestedImpl();
    }
    public RoleBindingNested<A> withNewRoleBindingLike( ClusterRoleBinding item){
    return new RoleBindingNestedImpl(item);
    }
    public RoleBindingNested<A> editRoleBinding(){
    return withNewRoleBindingLike(getRoleBinding());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedClusterRoleBindingFluentImpl that = (NamedClusterRoleBindingFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (roleBinding != null ? !roleBinding.equals(that.roleBinding) :that.roleBinding != null) return false;
return true;

    }

    public class RoleBindingNestedImpl<N> extends ClusterRoleBindingFluentImpl<RoleBindingNested<N>> implements RoleBindingNested<N>{

        private final ClusterRoleBindingBuilder builder;
    
             RoleBindingNestedImpl (){
        this.builder = new ClusterRoleBindingBuilder(this);
        }
             RoleBindingNestedImpl ( ClusterRoleBinding item){
        this.builder = new ClusterRoleBindingBuilder(this, item);
        }
    
            public N endRoleBinding(){
            return and();
        }
            public N and(){
            return (N) NamedClusterRoleBindingFluentImpl.this.withRoleBinding(builder.build());
        }
    
}


}
