package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class OAuthAccessTokenFluentImpl<A extends OAuthAccessTokenFluent<A>> extends BaseFluent<A> implements OAuthAccessTokenFluent<A>{

     String apiVersion;     String authorizeToken;     String clientName;     Long expiresIn;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     String redirectURI;     String refreshToken;     List<String> scopes = new ArrayList();     String userName;     String userUID;
public OAuthAccessTokenFluentImpl(){
    
}
public OAuthAccessTokenFluentImpl( OAuthAccessToken instance ){
    this.withApiVersion(instance.getApiVersion()); this.withAuthorizeToken(instance.getAuthorizeToken()); this.withClientName(instance.getClientName()); this.withExpiresIn(instance.getExpiresIn()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRedirectURI(instance.getRedirectURI()); this.withRefreshToken(instance.getRefreshToken()); this.withScopes(instance.getScopes()); this.withUserName(instance.getUserName()); this.withUserUID(instance.getUserUID()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getAuthorizeToken(){
    return this.authorizeToken;
    }
    public A withAuthorizeToken( String authorizeToken){
    this.authorizeToken=authorizeToken; return (A) this;
    }
    public String getClientName(){
    return this.clientName;
    }
    public A withClientName( String clientName){
    this.clientName=clientName; return (A) this;
    }
    public Long getExpiresIn(){
    return this.expiresIn;
    }
    public A withExpiresIn( Long expiresIn){
    this.expiresIn=expiresIn; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getRedirectURI(){
    return this.redirectURI;
    }
    public A withRedirectURI( String redirectURI){
    this.redirectURI=redirectURI; return (A) this;
    }
    public String getRefreshToken(){
    return this.refreshToken;
    }
    public A withRefreshToken( String refreshToken){
    this.refreshToken=refreshToken; return (A) this;
    }
    public A addToScopes( String ...items){
    for (String item : items) {this.scopes.add(item);} return (A)this;
    }
    public A removeFromScopes( String ...items){
    for (String item : items) {this.scopes.remove(item);} return (A)this;
    }
    public List<String> getScopes(){
    return this.scopes;
    }
    public A withScopes( List<String> scopes){
    this.scopes.clear();if (scopes != null) {for (String item : scopes){this.addToScopes(item);}} return (A) this;
    }
    public A withScopes( String ...scopes){
    this.scopes.clear(); if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
    }
    public String getUserName(){
    return this.userName;
    }
    public A withUserName( String userName){
    this.userName=userName; return (A) this;
    }
    public String getUserUID(){
    return this.userUID;
    }
    public A withUserUID( String userUID){
    this.userUID=userUID; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
OAuthAccessTokenFluentImpl that = (OAuthAccessTokenFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (authorizeToken != null ? !authorizeToken.equals(that.authorizeToken) :that.authorizeToken != null) return false;
if (clientName != null ? !clientName.equals(that.clientName) :that.clientName != null) return false;
if (expiresIn != null ? !expiresIn.equals(that.expiresIn) :that.expiresIn != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (redirectURI != null ? !redirectURI.equals(that.redirectURI) :that.redirectURI != null) return false;
if (refreshToken != null ? !refreshToken.equals(that.refreshToken) :that.refreshToken != null) return false;
if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
if (userName != null ? !userName.equals(that.userName) :that.userName != null) return false;
if (userUID != null ? !userUID.equals(that.userUID) :that.userUID != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) OAuthAccessTokenFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
