package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class OAuthAuthorizeTokenBuilder extends OAuthAuthorizeTokenFluentImpl<OAuthAuthorizeTokenBuilder> implements VisitableBuilder<OAuthAuthorizeToken,OAuthAuthorizeTokenBuilder>{

     OAuthAuthorizeTokenFluent<?> fluent;
public OAuthAuthorizeTokenBuilder(){
    this(new OAuthAuthorizeToken());
}
public OAuthAuthorizeTokenBuilder( OAuthAuthorizeTokenFluent<?> fluent ){
    this(fluent, new OAuthAuthorizeToken());
}
public OAuthAuthorizeTokenBuilder( OAuthAuthorizeTokenFluent<?> fluent , OAuthAuthorizeToken instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withClientName(instance.getClientName()); fluent.withExpiresIn(instance.getExpiresIn()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRedirectURI(instance.getRedirectURI()); fluent.withScopes(instance.getScopes()); fluent.withState(instance.getState()); fluent.withUserName(instance.getUserName()); fluent.withUserUID(instance.getUserUID()); 
}
public OAuthAuthorizeTokenBuilder( OAuthAuthorizeToken instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withClientName(instance.getClientName()); this.withExpiresIn(instance.getExpiresIn()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRedirectURI(instance.getRedirectURI()); this.withScopes(instance.getScopes()); this.withState(instance.getState()); this.withUserName(instance.getUserName()); this.withUserUID(instance.getUserUID()); 
}

public OAuthAuthorizeToken build(){
    OAuthAuthorizeToken buildable = new OAuthAuthorizeToken(fluent.getApiVersion(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getScopes(),fluent.getState(),fluent.getUserName(),fluent.getUserUID());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
OAuthAuthorizeTokenBuilder that = (OAuthAuthorizeTokenBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
