package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class RecreateDeploymentStrategyParamsBuilder extends RecreateDeploymentStrategyParamsFluentImpl<RecreateDeploymentStrategyParamsBuilder> implements VisitableBuilder<RecreateDeploymentStrategyParams,RecreateDeploymentStrategyParamsBuilder>{

     RecreateDeploymentStrategyParamsFluent<?> fluent;
public RecreateDeploymentStrategyParamsBuilder(){
    this(new RecreateDeploymentStrategyParams());
}
public RecreateDeploymentStrategyParamsBuilder( RecreateDeploymentStrategyParamsFluent<?> fluent ){
    this(fluent, new RecreateDeploymentStrategyParams());
}
public RecreateDeploymentStrategyParamsBuilder( RecreateDeploymentStrategyParamsFluent<?> fluent , RecreateDeploymentStrategyParams instance ){
    this.fluent = fluent; fluent.withMid(instance.getMid()); fluent.withPost(instance.getPost()); fluent.withPre(instance.getPre()); fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
}
public RecreateDeploymentStrategyParamsBuilder( RecreateDeploymentStrategyParams instance ){
    this.fluent = this; this.withMid(instance.getMid()); this.withPost(instance.getPost()); this.withPre(instance.getPre()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
}

public RecreateDeploymentStrategyParams build(){
    RecreateDeploymentStrategyParams buildable = new RecreateDeploymentStrategyParams(fluent.getMid(),fluent.getPost(),fluent.getPre(),fluent.getTimeoutSeconds());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RecreateDeploymentStrategyParamsBuilder that = (RecreateDeploymentStrategyParamsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
