package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class RoleBindingBuilder extends RoleBindingFluentImpl<RoleBindingBuilder> implements VisitableBuilder<RoleBinding,RoleBindingBuilder>{

     RoleBindingFluent<?> fluent;
public RoleBindingBuilder(){
    this(new RoleBinding());
}
public RoleBindingBuilder( RoleBindingFluent<?> fluent ){
    this(fluent, new RoleBinding());
}
public RoleBindingBuilder( RoleBindingFluent<?> fluent , RoleBinding instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withGroupNames(instance.getGroupNames()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRoleRef(instance.getRoleRef()); fluent.withSubjects(instance.getSubjects()); fluent.withUserNames(instance.getUserNames()); 
}
public RoleBindingBuilder( RoleBinding instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withGroupNames(instance.getGroupNames()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRoleRef(instance.getRoleRef()); this.withSubjects(instance.getSubjects()); this.withUserNames(instance.getUserNames()); 
}

public RoleBinding build(){
    RoleBinding buildable = new RoleBinding(fluent.getApiVersion(),fluent.getGroupNames(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects(),fluent.getUserNames());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RoleBindingBuilder that = (RoleBindingBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
