package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class RollingDeploymentStrategyParamsBuilder extends RollingDeploymentStrategyParamsFluentImpl<RollingDeploymentStrategyParamsBuilder> implements VisitableBuilder<RollingDeploymentStrategyParams,RollingDeploymentStrategyParamsBuilder>{

     RollingDeploymentStrategyParamsFluent<?> fluent;
public RollingDeploymentStrategyParamsBuilder(){
    this(new RollingDeploymentStrategyParams());
}
public RollingDeploymentStrategyParamsBuilder( RollingDeploymentStrategyParamsFluent<?> fluent ){
    this(fluent, new RollingDeploymentStrategyParams());
}
public RollingDeploymentStrategyParamsBuilder( RollingDeploymentStrategyParamsFluent<?> fluent , RollingDeploymentStrategyParams instance ){
    this.fluent = fluent; fluent.withIntervalSeconds(instance.getIntervalSeconds()); fluent.withMaxSurge(instance.getMaxSurge()); fluent.withMaxUnavailable(instance.getMaxUnavailable()); fluent.withPost(instance.getPost()); fluent.withPre(instance.getPre()); fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); fluent.withUpdatePercent(instance.getUpdatePercent()); fluent.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
}
public RollingDeploymentStrategyParamsBuilder( RollingDeploymentStrategyParams instance ){
    this.fluent = this; this.withIntervalSeconds(instance.getIntervalSeconds()); this.withMaxSurge(instance.getMaxSurge()); this.withMaxUnavailable(instance.getMaxUnavailable()); this.withPost(instance.getPost()); this.withPre(instance.getPre()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); this.withUpdatePercent(instance.getUpdatePercent()); this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
}

public RollingDeploymentStrategyParams build(){
    RollingDeploymentStrategyParams buildable = new RollingDeploymentStrategyParams(fluent.getIntervalSeconds(),fluent.getMaxSurge(),fluent.getMaxUnavailable(),fluent.getPost(),fluent.getPre(),fluent.getTimeoutSeconds(),fluent.getUpdatePercent(),fluent.getUpdatePeriodSeconds());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RollingDeploymentStrategyParamsBuilder that = (RollingDeploymentStrategyParamsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
