package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;

public class RouteIngressFluentImpl<A extends RouteIngressFluent<A>> extends BaseFluent<A> implements RouteIngressFluent<A>{

     List<VisitableBuilder<RouteIngressCondition, ?>> conditions = new ArrayList();     String host;     String routerName;
public RouteIngressFluentImpl(){
    
}
public RouteIngressFluentImpl( RouteIngress instance ){
    this.withConditions(instance.getConditions()); this.withHost(instance.getHost()); this.withRouterName(instance.getRouterName()); 
}

    public A addToConditions( RouteIngressCondition ...items){
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }
    public A removeFromConditions( RouteIngressCondition ...items){
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }
    public List<RouteIngressCondition> getConditions(){
    return build(conditions);
    }
    public A withConditions( List<RouteIngressCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (RouteIngressCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }
    public A withConditions( RouteIngressCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (RouteIngressCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }
    public ConditionsNested<A> addNewCondition(){
    return new ConditionsNestedImpl();
    }
    public ConditionsNested<A> addNewConditionLike( RouteIngressCondition item){
    return new ConditionsNestedImpl(item);
    }
    public A addNewCondition( String lastTransitionTime,  String message,  String reason,  String status,  String type){
    return addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
    }
    public String getHost(){
    return this.host;
    }
    public A withHost( String host){
    this.host=host; return (A) this;
    }
    public String getRouterName(){
    return this.routerName;
    }
    public A withRouterName( String routerName){
    this.routerName=routerName; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RouteIngressFluentImpl that = (RouteIngressFluentImpl) o;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (routerName != null ? !routerName.equals(that.routerName) :that.routerName != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends RouteIngressConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final RouteIngressConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new RouteIngressConditionBuilder(this);
        }
             ConditionsNestedImpl ( RouteIngressCondition item){
        this.builder = new RouteIngressConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) RouteIngressFluentImpl.this.addToConditions(builder.build());
        }
    
}


}
