package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class RoutePortFluentImpl<A extends RoutePortFluent<A>> extends BaseFluent<A> implements RoutePortFluent<A>{

     VisitableBuilder<IntOrString, ?> targetPort;
public RoutePortFluentImpl(){
    
}
public RoutePortFluentImpl( RoutePort instance ){
    this.withTargetPort(instance.getTargetPort()); 
}

    public IntOrString getTargetPort(){
    return this.targetPort!=null?this.targetPort.build():null;
    }
    public A withTargetPort( IntOrString targetPort){
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.add(this.targetPort);} return (A) this;
    }
    public TargetPortNested<A> withNewTargetPort(){
    return new TargetPortNestedImpl();
    }
    public TargetPortNested<A> withNewTargetPortLike( IntOrString item){
    return new TargetPortNestedImpl(item);
    }
    public TargetPortNested<A> editTargetPort(){
    return withNewTargetPortLike(getTargetPort());
    }
    public A withNewTargetPort( String strVal){
    return withTargetPort(new IntOrString(strVal));
    }
    public A withNewTargetPort( Integer intVal){
    return withTargetPort(new IntOrString(intVal));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RoutePortFluentImpl that = (RoutePortFluentImpl) o;
if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
return true;

    }

    public class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<TargetPortNested<N>> implements TargetPortNested<N>{

        private final IntOrStringBuilder builder;
    
             TargetPortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             TargetPortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endTargetPort(){
            return and();
        }
            public N and(){
            return (N) RoutePortFluentImpl.this.withTargetPort(builder.build());
        }
    
}


}
