package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface RouteSpecFluent<A extends RouteSpecFluent<A>> extends Fluent<A>{


    public String getHost();    public A withHost( String host);    public String getPath();    public A withPath( String path);    public RoutePort getPort();    public A withPort( RoutePort port);    public PortNested<A> withNewPort();    public PortNested<A> withNewPortLike( RoutePort item);    public PortNested<A> editPort();    public TLSConfig getTls();    public A withTls( TLSConfig tls);    public TlsNested<A> withNewTls();    public TlsNested<A> withNewTlsLike( TLSConfig item);    public TlsNested<A> editTls();    public ObjectReference getTo();    public A withTo( ObjectReference to);    public ToNested<A> withNewTo();    public ToNested<A> withNewToLike( ObjectReference item);    public ToNested<A> editTo();
    public interface PortNested<N> extends Nested<N>,RoutePortFluent<PortNested<N>>{
            public N endPort();            public N and();        
}

    public interface TlsNested<N> extends Nested<N>,TLSConfigFluent<TlsNested<N>>{
            public N endTls();            public N and();        
}

    public interface ToNested<N> extends Nested<N>,ObjectReferenceFluent<ToNested<N>>{
            public N and();            public N endTo();        
}


}
