package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class ScopeRestrictionFluentImpl<A extends ScopeRestrictionFluent<A>> extends BaseFluent<A> implements ScopeRestrictionFluent<A>{

     VisitableBuilder<ClusterRoleScopeRestriction, ?> clusterRole;     List<String> literals = new ArrayList();
public ScopeRestrictionFluentImpl(){
    
}
public ScopeRestrictionFluentImpl( ScopeRestriction instance ){
    this.withClusterRole(instance.getClusterRole()); this.withLiterals(instance.getLiterals()); 
}

    public ClusterRoleScopeRestriction getClusterRole(){
    return this.clusterRole!=null?this.clusterRole.build():null;
    }
    public A withClusterRole( ClusterRoleScopeRestriction clusterRole){
    if (clusterRole!=null){ this.clusterRole= new ClusterRoleScopeRestrictionBuilder(clusterRole); _visitables.add(this.clusterRole);} return (A) this;
    }
    public ClusterRoleNested<A> withNewClusterRole(){
    return new ClusterRoleNestedImpl();
    }
    public ClusterRoleNested<A> withNewClusterRoleLike( ClusterRoleScopeRestriction item){
    return new ClusterRoleNestedImpl(item);
    }
    public ClusterRoleNested<A> editClusterRole(){
    return withNewClusterRoleLike(getClusterRole());
    }
    public A addToLiterals( String ...items){
    for (String item : items) {this.literals.add(item);} return (A)this;
    }
    public A removeFromLiterals( String ...items){
    for (String item : items) {this.literals.remove(item);} return (A)this;
    }
    public List<String> getLiterals(){
    return this.literals;
    }
    public A withLiterals( List<String> literals){
    this.literals.clear();if (literals != null) {for (String item : literals){this.addToLiterals(item);}} return (A) this;
    }
    public A withLiterals( String ...literals){
    this.literals.clear(); if (literals != null) {for (String item :literals){ this.addToLiterals(item);}} return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ScopeRestrictionFluentImpl that = (ScopeRestrictionFluentImpl) o;
if (clusterRole != null ? !clusterRole.equals(that.clusterRole) :that.clusterRole != null) return false;
if (literals != null ? !literals.equals(that.literals) :that.literals != null) return false;
return true;

    }

    public class ClusterRoleNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<ClusterRoleNested<N>> implements ClusterRoleNested<N>{

        private final ClusterRoleScopeRestrictionBuilder builder;
    
             ClusterRoleNestedImpl (){
        this.builder = new ClusterRoleScopeRestrictionBuilder(this);
        }
             ClusterRoleNestedImpl ( ClusterRoleScopeRestriction item){
        this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
        }
    
            public N and(){
            return (N) ScopeRestrictionFluentImpl.this.withClusterRole(builder.build());
        }
            public N endClusterRole(){
            return and();
        }
    
}


}
