package io.fabric8.openshift.api.model;

import java.util.List;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface SourceBuildStrategyFluent<A extends SourceBuildStrategyFluent<A>> extends Fluent<A>{


    public A addToEnv( EnvVar ...items);    public A removeFromEnv( EnvVar ...items);    public List<EnvVar> getEnv();    public A withEnv( List<EnvVar> env);    public A withEnv( EnvVar ...env);    public EnvNested<A> addNewEnv();    public EnvNested<A> addNewEnvLike( EnvVar item);    public Boolean isForcePull();    public A withForcePull( Boolean forcePull);    public ObjectReference getFrom();    public A withFrom( ObjectReference from);    public FromNested<A> withNewFrom();    public FromNested<A> withNewFromLike( ObjectReference item);    public FromNested<A> editFrom();    public Boolean isIncremental();    public A withIncremental( Boolean incremental);    public LocalObjectReference getPullSecret();    public A withPullSecret( LocalObjectReference pullSecret);    public PullSecretNested<A> withNewPullSecret();    public PullSecretNested<A> withNewPullSecretLike( LocalObjectReference item);    public PullSecretNested<A> editPullSecret();    public A withNewPullSecret( String name);    public String getScripts();    public A withScripts( String scripts);
    public interface EnvNested<N> extends Nested<N>,EnvVarFluent<EnvNested<N>>{
            public N endEnv();            public N and();        
}

    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<FromNested<N>>{
            public N endFrom();            public N and();        
}

    public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<PullSecretNested<N>>{
            public N and();            public N endPullSecret();        
}


}
