package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class SourceControlUserBuilder extends SourceControlUserFluentImpl<SourceControlUserBuilder> implements VisitableBuilder<SourceControlUser,SourceControlUserBuilder>{

     SourceControlUserFluent<?> fluent;
public SourceControlUserBuilder(){
    this(new SourceControlUser());
}
public SourceControlUserBuilder( SourceControlUserFluent<?> fluent ){
    this(fluent, new SourceControlUser());
}
public SourceControlUserBuilder( SourceControlUserFluent<?> fluent , SourceControlUser instance ){
    this.fluent = fluent; fluent.withEmail(instance.getEmail()); fluent.withName(instance.getName()); 
}
public SourceControlUserBuilder( SourceControlUser instance ){
    this.fluent = this; this.withEmail(instance.getEmail()); this.withName(instance.getName()); 
}

public SourceControlUser build(){
    SourceControlUser buildable = new SourceControlUser(fluent.getEmail(),fluent.getName());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SourceControlUserBuilder that = (SourceControlUserBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
