package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class SourceRevisionFluentImpl<A extends SourceRevisionFluent<A>> extends BaseFluent<A> implements SourceRevisionFluent<A>{

     VisitableBuilder<GitSourceRevision, ?> git;     String type;
public SourceRevisionFluentImpl(){
    
}
public SourceRevisionFluentImpl( SourceRevision instance ){
    this.withGit(instance.getGit()); this.withType(instance.getType()); 
}

    public GitSourceRevision getGit(){
    return this.git!=null?this.git.build():null;
    }
    public A withGit( GitSourceRevision git){
    if (git!=null){ this.git= new GitSourceRevisionBuilder(git); _visitables.add(this.git);} return (A) this;
    }
    public GitNested<A> withNewGit(){
    return new GitNestedImpl();
    }
    public GitNested<A> withNewGitLike( GitSourceRevision item){
    return new GitNestedImpl(item);
    }
    public GitNested<A> editGit(){
    return withNewGitLike(getGit());
    }
    public String getType(){
    return this.type;
    }
    public A withType( String type){
    this.type=type; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SourceRevisionFluentImpl that = (SourceRevisionFluentImpl) o;
if (git != null ? !git.equals(that.git) :that.git != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
return true;

    }

    public class GitNestedImpl<N> extends GitSourceRevisionFluentImpl<GitNested<N>> implements GitNested<N>{

        private final GitSourceRevisionBuilder builder;
    
             GitNestedImpl ( GitSourceRevision item){
        this.builder = new GitSourceRevisionBuilder(this, item);
        }
             GitNestedImpl (){
        this.builder = new GitSourceRevisionBuilder(this);
        }
    
            public N and(){
            return (N) SourceRevisionFluentImpl.this.withGit(builder.build());
        }
            public N endGit(){
            return and();
        }
    
}


}
