package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface TagReferenceFluent<A extends TagReferenceFluent<A>> extends Fluent<A>{


    public A addToAnnotations( String key,  String value);    public A addToAnnotations( Map<String, String> map);    public A removeFromAnnotations( String key);    public A removeFromAnnotations( Map<String, String> map);    public Map<String, String> getAnnotations();    public A withAnnotations( Map<String, String> annotations);    public ObjectReference getFrom();    public A withFrom( ObjectReference from);    public FromNested<A> withNewFrom();    public FromNested<A> withNewFromLike( ObjectReference item);    public FromNested<A> editFrom();    public Long getGeneration();    public A withGeneration( Long generation);    public TagImportPolicy getImportPolicy();    public A withImportPolicy( TagImportPolicy importPolicy);    public ImportPolicyNested<A> withNewImportPolicy();    public ImportPolicyNested<A> withNewImportPolicyLike( TagImportPolicy item);    public ImportPolicyNested<A> editImportPolicy();    public A withNewImportPolicy( Boolean insecure,  Boolean scheduled);    public String getName();    public A withName( String name);    public Boolean isReference();    public A withReference( Boolean reference);
    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<FromNested<N>>{
            public N endFrom();            public N and();        
}

    public interface ImportPolicyNested<N> extends Nested<N>,TagImportPolicyFluent<ImportPolicyNested<N>>{
            public N endImportPolicy();            public N and();        
}


}
