/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.AuthInfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AuthInfoBuilder
extends AuthInfoFluentImpl<AuthInfoBuilder>
implements VisitableBuilder<AuthInfo, AuthInfoBuilder> {
    AuthInfoFluent<?> fluent;

    public AuthInfoBuilder() {
        this(new AuthInfo());
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent) {
        this(fluent, new AuthInfo());
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent, AuthInfo instance) {
        this.fluent = fluent;
        fluent.withAs(instance.getAs());
        fluent.withClientCertificate(instance.getClientCertificate());
        fluent.withClientCertificateData(instance.getClientCertificateData());
        fluent.withClientKey(instance.getClientKey());
        fluent.withClientKeyData(instance.getClientKeyData());
        fluent.withExtensions(instance.getExtensions());
        fluent.withPassword(instance.getPassword());
        fluent.withToken(instance.getToken());
        fluent.withUsername(instance.getUsername());
    }

    public AuthInfoBuilder(AuthInfo instance) {
        this.fluent = this;
        this.withAs(instance.getAs());
        this.withClientCertificate(instance.getClientCertificate());
        this.withClientCertificateData(instance.getClientCertificateData());
        this.withClientKey(instance.getClientKey());
        this.withClientKeyData(instance.getClientKeyData());
        this.withExtensions(instance.getExtensions());
        this.withPassword(instance.getPassword());
        this.withToken(instance.getToken());
        this.withUsername(instance.getUsername());
    }

    @Override
    public AuthInfo build() {
        AuthInfo buildable = new AuthInfo(this.fluent.getAs(), this.fluent.getClientCertificate(), this.fluent.getClientCertificateData(), this.fluent.getClientKey(), this.fluent.getClientKeyData(), this.fluent.getExtensions(), this.fluent.getPassword(), this.fluent.getToken(), this.fluent.getUsername());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthInfoBuilder that = (AuthInfoBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

