/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.api.model.ContainerImageFluent;
import io.fabric8.kubernetes.api.model.ContainerImageFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerImageBuilder
extends ContainerImageFluentImpl<ContainerImageBuilder>
implements VisitableBuilder<ContainerImage, ContainerImageBuilder> {
    ContainerImageFluent<?> fluent;

    public ContainerImageBuilder() {
        this(new ContainerImage());
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent) {
        this(fluent, new ContainerImage());
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance) {
        this.fluent = fluent;
        fluent.withNames(instance.getNames());
        fluent.withSizeBytes(instance.getSizeBytes());
    }

    public ContainerImageBuilder(ContainerImage instance) {
        this.fluent = this;
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
    }

    @Override
    public ContainerImage build() {
        ContainerImage buildable = new ContainerImage(this.fluent.getNames(), this.fluent.getSizeBytes());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerImageBuilder that = (ContainerImageBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

