/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerPortBuilder
extends ContainerPortFluentImpl<ContainerPortBuilder>
implements VisitableBuilder<ContainerPort, ContainerPortBuilder> {
    ContainerPortFluent<?> fluent;

    public ContainerPortBuilder() {
        this(new ContainerPort());
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent) {
        this(fluent, new ContainerPort());
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance) {
        this.fluent = fluent;
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withHostIP(instance.getHostIP());
        fluent.withHostPort(instance.getHostPort());
        fluent.withName(instance.getName());
        fluent.withProtocol(instance.getProtocol());
    }

    public ContainerPortBuilder(ContainerPort instance) {
        this.fluent = this;
        this.withContainerPort(instance.getContainerPort());
        this.withHostIP(instance.getHostIP());
        this.withHostPort(instance.getHostPort());
        this.withName(instance.getName());
        this.withProtocol(instance.getProtocol());
    }

    @Override
    public ContainerPort build() {
        ContainerPort buildable = new ContainerPort(this.fluent.getContainerPort(), this.fluent.getHostIP(), this.fluent.getHostPort(), this.fluent.getName(), this.fluent.getProtocol());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerPortBuilder that = (ContainerPortBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

