/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStateFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateBuilder
extends ContainerStateFluentImpl<ContainerStateBuilder>
implements VisitableBuilder<ContainerState, ContainerStateBuilder> {
    ContainerStateFluent<?> fluent;

    public ContainerStateBuilder() {
        this(new ContainerState());
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
        this(fluent, new ContainerState());
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance) {
        this.fluent = fluent;
        fluent.withRunning(instance.getRunning());
        fluent.withTerminated(instance.getTerminated());
        fluent.withWaiting(instance.getWaiting());
    }

    public ContainerStateBuilder(ContainerState instance) {
        this.fluent = this;
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
    }

    @Override
    public ContainerState build() {
        ContainerState buildable = new ContainerState(this.fluent.getRunning(), this.fluent.getTerminated(), this.fluent.getWaiting());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateBuilder that = (ContainerStateBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

