/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;

public class ContainerStatusFluentImpl<A extends ContainerStatusFluent<A>>
extends BaseFluent<A>
implements ContainerStatusFluent<A> {
    String containerID;
    String image;
    String imageID;
    VisitableBuilder<ContainerState, ?> lastState;
    String name;
    Boolean ready;
    Integer restartCount;
    VisitableBuilder<ContainerState, ?> state;

    public ContainerStatusFluentImpl() {
    }

    public ContainerStatusFluentImpl(ContainerStatus instance) {
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withImageID(instance.getImageID());
        this.withLastState(instance.getLastState());
        this.withName(instance.getName());
        this.withReady(instance.getReady());
        this.withRestartCount(instance.getRestartCount());
        this.withState(instance.getState());
    }

    @Override
    public String getContainerID() {
        return this.containerID;
    }

    @Override
    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)this;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    @Override
    public ContainerState getLastState() {
        return this.lastState != null ? (ContainerState)this.lastState.build() : null;
    }

    @Override
    public A withLastState(ContainerState lastState) {
        if (lastState != null) {
            this.lastState = new ContainerStateBuilder(lastState);
            this._visitables.add(this.lastState);
        }
        return (A)this;
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> withNewLastState() {
        return new LastStateNestedImpl();
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(ContainerState item) {
        return new LastStateNestedImpl(item);
    }

    @Override
    public ContainerStatusFluent.LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(this.getLastState());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean isReady() {
        return this.ready;
    }

    @Override
    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)this;
    }

    @Override
    public Integer getRestartCount() {
        return this.restartCount;
    }

    @Override
    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)this;
    }

    @Override
    public ContainerState getState() {
        return this.state != null ? (ContainerState)this.state.build() : null;
    }

    @Override
    public A withState(ContainerState state) {
        if (state != null) {
            this.state = new ContainerStateBuilder(state);
            this._visitables.add(this.state);
        }
        return (A)this;
    }

    @Override
    public ContainerStatusFluent.StateNested<A> withNewState() {
        return new StateNestedImpl();
    }

    @Override
    public ContainerStatusFluent.StateNested<A> withNewStateLike(ContainerState item) {
        return new StateNestedImpl(item);
    }

    @Override
    public ContainerStatusFluent.StateNested<A> editState() {
        return this.withNewStateLike(this.getState());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStatusFluentImpl that = (ContainerStatusFluentImpl)o;
        if (this.containerID != null ? !this.containerID.equals(that.containerID) : that.containerID != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageID != null ? !this.imageID.equals(that.imageID) : that.imageID != null) {
            return false;
        }
        if (this.lastState != null ? !this.lastState.equals(that.lastState) : that.lastState != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ready != null ? !this.ready.equals(that.ready) : that.ready != null) {
            return false;
        }
        if (this.restartCount != null ? !this.restartCount.equals(that.restartCount) : that.restartCount != null) {
            return false;
        }
        return !(this.state != null ? !this.state.equals(that.state) : that.state != null);
    }

    public class StateNestedImpl<N>
    extends ContainerStateFluentImpl<ContainerStatusFluent.StateNested<N>>
    implements ContainerStatusFluent.StateNested<N> {
        private final ContainerStateBuilder builder;

        StateNestedImpl() {
            this.builder = new ContainerStateBuilder(this);
        }

        StateNestedImpl(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerStatusFluentImpl.this.withState(this.builder.build());
        }

        @Override
        public N endState() {
            return this.and();
        }
    }

    public class LastStateNestedImpl<N>
    extends ContainerStateFluentImpl<ContainerStatusFluent.LastStateNested<N>>
    implements ContainerStatusFluent.LastStateNested<N> {
        private final ContainerStateBuilder builder;

        LastStateNestedImpl() {
            this.builder = new ContainerStateBuilder(this);
        }

        LastStateNestedImpl(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        @Override
        public N endLastState() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerStatusFluentImpl.this.withLastState(this.builder.build());
        }
    }
}

