/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointPortFluent;
import io.fabric8.kubernetes.api.model.EndpointPortFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointPortBuilder
extends EndpointPortFluentImpl<EndpointPortBuilder>
implements VisitableBuilder<EndpointPort, EndpointPortBuilder> {
    EndpointPortFluent<?> fluent;

    public EndpointPortBuilder() {
        this(new EndpointPort());
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent) {
        this(fluent, new EndpointPort());
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent, EndpointPort instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
    }

    public EndpointPortBuilder(EndpointPort instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
    }

    @Override
    public EndpointPort build() {
        EndpointPort buildable = new EndpointPort(this.fluent.getName(), this.fluent.getPort(), this.fluent.getProtocol());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointPortBuilder that = (EndpointPortBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

