/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EnvVarBuilder
extends EnvVarFluentImpl<EnvVarBuilder>
implements VisitableBuilder<EnvVar, EnvVarBuilder> {
    EnvVarFluent<?> fluent;

    public EnvVarBuilder() {
        this(new EnvVar());
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent) {
        this(fluent, new EnvVar());
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        fluent.withValueFrom(instance.getValueFrom());
    }

    public EnvVarBuilder(EnvVar instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
    }

    @Override
    public EnvVar build() {
        EnvVar buildable = new EnvVar(this.fluent.getName(), this.fluent.getValue(), this.fluent.getValueFrom());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvVarBuilder that = (EnvVarBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

