/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.SecretKeySelectorFluentImpl;

public class EnvVarSourceFluentImpl<A extends EnvVarSourceFluent<A>>
extends BaseFluent<A>
implements EnvVarSourceFluent<A> {
    VisitableBuilder<ConfigMapKeySelector, ?> configMapKeyRef;
    VisitableBuilder<ObjectFieldSelector, ?> fieldRef;
    VisitableBuilder<SecretKeySelector, ?> secretKeyRef;

    public EnvVarSourceFluentImpl() {
    }

    public EnvVarSourceFluentImpl(EnvVarSource instance) {
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        this.withFieldRef(instance.getFieldRef());
        this.withSecretKeyRef(instance.getSecretKeyRef());
    }

    @Override
    public ConfigMapKeySelector getConfigMapKeyRef() {
        return this.configMapKeyRef != null ? (ConfigMapKeySelector)this.configMapKeyRef.build() : null;
    }

    @Override
    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef) {
        if (configMapKeyRef != null) {
            this.configMapKeyRef = new ConfigMapKeySelectorBuilder(configMapKeyRef);
            this._visitables.add(this.configMapKeyRef);
        }
        return (A)this;
    }

    @Override
    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRef() {
        return new ConfigMapKeyRefNestedImpl();
    }

    @Override
    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> withNewConfigMapKeyRefLike(ConfigMapKeySelector item) {
        return new ConfigMapKeyRefNestedImpl(item);
    }

    @Override
    public EnvVarSourceFluent.ConfigMapKeyRefNested<A> editConfigMapKeyRef() {
        return this.withNewConfigMapKeyRefLike(this.getConfigMapKeyRef());
    }

    @Override
    public A withNewConfigMapKeyRef(String key, String name) {
        return this.withConfigMapKeyRef(new ConfigMapKeySelector(key, name));
    }

    @Override
    public ObjectFieldSelector getFieldRef() {
        return this.fieldRef != null ? (ObjectFieldSelector)this.fieldRef.build() : null;
    }

    @Override
    public A withFieldRef(ObjectFieldSelector fieldRef) {
        if (fieldRef != null) {
            this.fieldRef = new ObjectFieldSelectorBuilder(fieldRef);
            this._visitables.add(this.fieldRef);
        }
        return (A)this;
    }

    @Override
    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRef() {
        return new FieldRefNestedImpl();
    }

    @Override
    public EnvVarSourceFluent.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item) {
        return new FieldRefNestedImpl(item);
    }

    @Override
    public EnvVarSourceFluent.FieldRefNested<A> editFieldRef() {
        return this.withNewFieldRefLike(this.getFieldRef());
    }

    @Override
    public A withNewFieldRef(String apiVersion, String fieldPath) {
        return this.withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    @Override
    public SecretKeySelector getSecretKeyRef() {
        return this.secretKeyRef != null ? (SecretKeySelector)this.secretKeyRef.build() : null;
    }

    @Override
    public A withSecretKeyRef(SecretKeySelector secretKeyRef) {
        if (secretKeyRef != null) {
            this.secretKeyRef = new SecretKeySelectorBuilder(secretKeyRef);
            this._visitables.add(this.secretKeyRef);
        }
        return (A)this;
    }

    @Override
    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRef() {
        return new SecretKeyRefNestedImpl();
    }

    @Override
    public EnvVarSourceFluent.SecretKeyRefNested<A> withNewSecretKeyRefLike(SecretKeySelector item) {
        return new SecretKeyRefNestedImpl(item);
    }

    @Override
    public EnvVarSourceFluent.SecretKeyRefNested<A> editSecretKeyRef() {
        return this.withNewSecretKeyRefLike(this.getSecretKeyRef());
    }

    @Override
    public A withNewSecretKeyRef(String key, String name) {
        return this.withSecretKeyRef(new SecretKeySelector(key, name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvVarSourceFluentImpl that = (EnvVarSourceFluentImpl)o;
        if (this.configMapKeyRef != null ? !this.configMapKeyRef.equals(that.configMapKeyRef) : that.configMapKeyRef != null) {
            return false;
        }
        if (this.fieldRef != null ? !this.fieldRef.equals(that.fieldRef) : that.fieldRef != null) {
            return false;
        }
        return !(this.secretKeyRef != null ? !this.secretKeyRef.equals(that.secretKeyRef) : that.secretKeyRef != null);
    }

    public class SecretKeyRefNestedImpl<N>
    extends SecretKeySelectorFluentImpl<EnvVarSourceFluent.SecretKeyRefNested<N>>
    implements EnvVarSourceFluent.SecretKeyRefNested<N> {
        private final SecretKeySelectorBuilder builder;

        SecretKeyRefNestedImpl() {
            this.builder = new SecretKeySelectorBuilder(this);
        }

        SecretKeyRefNestedImpl(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        @Override
        public N endSecretKeyRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EnvVarSourceFluentImpl.this.withSecretKeyRef(this.builder.build());
        }
    }

    public class FieldRefNestedImpl<N>
    extends ObjectFieldSelectorFluentImpl<EnvVarSourceFluent.FieldRefNested<N>>
    implements EnvVarSourceFluent.FieldRefNested<N> {
        private final ObjectFieldSelectorBuilder builder;

        FieldRefNestedImpl() {
            this.builder = new ObjectFieldSelectorBuilder(this);
        }

        FieldRefNestedImpl(ObjectFieldSelector item) {
            this.builder = new ObjectFieldSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EnvVarSourceFluentImpl.this.withFieldRef(this.builder.build());
        }

        @Override
        public N endFieldRef() {
            return this.and();
        }
    }

    public class ConfigMapKeyRefNestedImpl<N>
    extends ConfigMapKeySelectorFluentImpl<EnvVarSourceFluent.ConfigMapKeyRefNested<N>>
    implements EnvVarSourceFluent.ConfigMapKeyRefNested<N> {
        private final ConfigMapKeySelectorBuilder builder;

        ConfigMapKeyRefNestedImpl() {
            this.builder = new ConfigMapKeySelectorBuilder(this);
        }

        ConfigMapKeyRefNestedImpl(ConfigMapKeySelector item) {
            this.builder = new ConfigMapKeySelectorBuilder(this, item);
        }

        @Override
        public N endConfigMapKeyRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EnvVarSourceFluentImpl.this.withConfigMapKeyRef(this.builder.build());
        }
    }
}

