/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.ExecActionFluent;
import io.fabric8.kubernetes.api.model.ExecActionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ExecActionBuilder
extends ExecActionFluentImpl<ExecActionBuilder>
implements VisitableBuilder<ExecAction, ExecActionBuilder> {
    ExecActionFluent<?> fluent;

    public ExecActionBuilder() {
        this(new ExecAction());
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent) {
        this(fluent, new ExecAction());
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, ExecAction instance) {
        this.fluent = fluent;
        fluent.withCommand(instance.getCommand());
    }

    public ExecActionBuilder(ExecAction instance) {
        this.fluent = this;
        this.withCommand(instance.getCommand());
    }

    @Override
    public ExecAction build() {
        ExecAction buildable = new ExecAction(this.fluent.getCommand());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecActionBuilder that = (ExecActionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

