/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.HTTPHeaderFluent;
import io.fabric8.kubernetes.api.model.HTTPHeaderFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HTTPHeaderBuilder
extends HTTPHeaderFluentImpl<HTTPHeaderBuilder>
implements VisitableBuilder<HTTPHeader, HTTPHeaderBuilder> {
    HTTPHeaderFluent<?> fluent;

    public HTTPHeaderBuilder() {
        this(new HTTPHeader());
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent) {
        this(fluent, new HTTPHeader());
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, HTTPHeader instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
    }

    public HTTPHeaderBuilder(HTTPHeader instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
    }

    @Override
    public HTTPHeader build() {
        HTTPHeader buildable = new HTTPHeader(this.fluent.getName(), this.fluent.getValue());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPHeaderBuilder that = (HTTPHeaderBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

