/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.LifecycleFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LifecycleBuilder
extends LifecycleFluentImpl<LifecycleBuilder>
implements VisitableBuilder<Lifecycle, LifecycleBuilder> {
    LifecycleFluent<?> fluent;

    public LifecycleBuilder() {
        this(new Lifecycle());
    }

    public LifecycleBuilder(LifecycleFluent<?> fluent) {
        this(fluent, new Lifecycle());
    }

    public LifecycleBuilder(LifecycleFluent<?> fluent, Lifecycle instance) {
        this.fluent = fluent;
        fluent.withPostStart(instance.getPostStart());
        fluent.withPreStop(instance.getPreStop());
    }

    public LifecycleBuilder(Lifecycle instance) {
        this.fluent = this;
        this.withPostStart(instance.getPostStart());
        this.withPreStop(instance.getPreStop());
    }

    @Override
    public Lifecycle build() {
        Lifecycle buildable = new Lifecycle(this.fluent.getPostStart(), this.fluent.getPreStop());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LifecycleBuilder that = (LifecycleBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

