/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LimitRangeSpec;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluent;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LimitRangeSpecBuilder
extends LimitRangeSpecFluentImpl<LimitRangeSpecBuilder>
implements VisitableBuilder<LimitRangeSpec, LimitRangeSpecBuilder> {
    LimitRangeSpecFluent<?> fluent;

    public LimitRangeSpecBuilder() {
        this(new LimitRangeSpec());
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent) {
        this(fluent, new LimitRangeSpec());
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent, LimitRangeSpec instance) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
    }

    public LimitRangeSpecBuilder(LimitRangeSpec instance) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
    }

    @Override
    public LimitRangeSpec build() {
        LimitRangeSpec buildable = new LimitRangeSpec(this.fluent.getLimits());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeSpecBuilder that = (LimitRangeSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

