/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LocalObjectReferenceBuilder
extends LocalObjectReferenceFluentImpl<LocalObjectReferenceBuilder>
implements VisitableBuilder<LocalObjectReference, LocalObjectReferenceBuilder> {
    LocalObjectReferenceFluent<?> fluent;

    public LocalObjectReferenceBuilder() {
        this(new LocalObjectReference());
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent) {
        this(fluent, new LocalObjectReference());
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, LocalObjectReference instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
    }

    public LocalObjectReferenceBuilder(LocalObjectReference instance) {
        this.fluent = this;
        this.withName(instance.getName());
    }

    @Override
    public LocalObjectReference build() {
        LocalObjectReference buildable = new LocalObjectReference(this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalObjectReferenceBuilder that = (LocalObjectReferenceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

