/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.api.model.AuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;

public class NamedAuthInfoFluentImpl<A extends NamedAuthInfoFluent<A>>
extends BaseFluent<A>
implements NamedAuthInfoFluent<A> {
    String name;
    VisitableBuilder<AuthInfo, ?> user;

    public NamedAuthInfoFluentImpl() {
    }

    public NamedAuthInfoFluentImpl(NamedAuthInfo instance) {
        this.withName(instance.getName());
        this.withUser(instance.getUser());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public AuthInfo getUser() {
        return this.user != null ? (AuthInfo)this.user.build() : null;
    }

    @Override
    public A withUser(AuthInfo user) {
        if (user != null) {
            this.user = new AuthInfoBuilder(user);
            this._visitables.add(this.user);
        }
        return (A)this;
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUserLike(AuthInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class UserNestedImpl<N>
    extends AuthInfoFluentImpl<NamedAuthInfoFluent.UserNested<N>>
    implements NamedAuthInfoFluent.UserNested<N> {
        private final AuthInfoBuilder builder;

        UserNestedImpl() {
            this.builder = new AuthInfoBuilder(this);
        }

        UserNestedImpl(AuthInfo item) {
            this.builder = new AuthInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedAuthInfoFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

