/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.api.model.NamedContextFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamedContextBuilder
extends NamedContextFluentImpl<NamedContextBuilder>
implements VisitableBuilder<NamedContext, NamedContextBuilder> {
    NamedContextFluent<?> fluent;

    public NamedContextBuilder() {
        this(new NamedContext());
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent) {
        this(fluent, new NamedContext());
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, NamedContext instance) {
        this.fluent = fluent;
        fluent.withContext(instance.getContext());
        fluent.withName(instance.getName());
    }

    public NamedContextBuilder(NamedContext instance) {
        this.fluent = this;
        this.withContext(instance.getContext());
        this.withName(instance.getName());
    }

    @Override
    public NamedContext build() {
        NamedContext buildable = new NamedContext(this.fluent.getContext(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedContextBuilder that = (NamedContextBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

