/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.NodeStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeStatusBuilder
extends NodeStatusFluentImpl<NodeStatusBuilder>
implements VisitableBuilder<NodeStatus, NodeStatusBuilder> {
    NodeStatusFluent<?> fluent;

    public NodeStatusBuilder() {
        this(new NodeStatus());
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
        this(fluent, new NodeStatus());
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withAllocatable(instance.getAllocatable());
        fluent.withCapacity(instance.getCapacity());
        fluent.withConditions(instance.getConditions());
        fluent.withDaemonEndpoints(instance.getDaemonEndpoints());
        fluent.withImages(instance.getImages());
        fluent.withNodeInfo(instance.getNodeInfo());
        fluent.withPhase(instance.getPhase());
    }

    public NodeStatusBuilder(NodeStatus instance) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
    }

    @Override
    public NodeStatus build() {
        NodeStatus buildable = new NodeStatus(this.fluent.getAddresses(), this.fluent.getAllocatable(), this.fluent.getCapacity(), this.fluent.getConditions(), this.fluent.getDaemonEndpoints(), this.fluent.getImages(), this.fluent.getNodeInfo(), this.fluent.getPhase());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusBuilder that = (NodeStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

