/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.api.model.ContainerImageBuilder;
import io.fabric8.kubernetes.api.model.ContainerImageFluentImpl;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeAddressBuilder;
import io.fabric8.kubernetes.api.model.NodeAddressFluentImpl;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeConditionBuilder;
import io.fabric8.kubernetes.api.model.NodeConditionFluentImpl;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluentImpl;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>>
extends BaseFluent<A>
implements NodeStatusFluent<A> {
    List<VisitableBuilder<NodeAddress, ?>> addresses = new ArrayList();
    Map<String, Quantity> allocatable = new HashMap<String, Quantity>();
    Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    List<VisitableBuilder<NodeCondition, ?>> conditions = new ArrayList();
    VisitableBuilder<NodeDaemonEndpoints, ?> daemonEndpoints;
    List<VisitableBuilder<ContainerImage, ?>> images = new ArrayList();
    VisitableBuilder<NodeSystemInfo, ?> nodeInfo;
    String phase;

    public NodeStatusFluentImpl() {
    }

    public NodeStatusFluentImpl(NodeStatus instance) {
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
    }

    @Override
    public A addToAddresses(NodeAddress ... items) {
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(NodeAddress ... items) {
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NodeAddress> getAddresses() {
        return this.build(this.addresses);
    }

    @Override
    public A withAddresses(List<NodeAddress> addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAddresses(NodeAddress ... addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> addNewAddresse() {
        return new AddressesNestedImpl();
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> addNewAddresseLike(NodeAddress item) {
        return new AddressesNestedImpl(item);
    }

    @Override
    public A addNewAddresse(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    @Override
    public A addToAllocatable(String key, Quantity value) {
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAllocatable(Map<String, Quantity> map) {
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(String key) {
        if (key != null) {
            this.allocatable.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.allocatable.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    @Override
    public A withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable.clear();
        if (allocatable != null) {
            this.allocatable.putAll(allocatable);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (key != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(NodeCondition ... items) {
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(NodeCondition ... items) {
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NodeCondition> getConditions() {
        return this.build(this.conditions);
    }

    @Override
    public A withConditions(List<NodeCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(NodeCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> addNewConditionLike(NodeCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints != null ? (NodeDaemonEndpoints)this.daemonEndpoints.build() : null;
    }

    @Override
    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
        if (daemonEndpoints != null) {
            this.daemonEndpoints = new NodeDaemonEndpointsBuilder(daemonEndpoints);
            this._visitables.add(this.daemonEndpoints);
        }
        return (A)this;
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints() {
        return new DaemonEndpointsNestedImpl();
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return new DaemonEndpointsNestedImpl(item);
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints());
    }

    @Override
    public A addToImages(ContainerImage ... items) {
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ContainerImage ... items) {
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ContainerImage> getImages() {
        return this.build(this.images);
    }

    @Override
    public A withImages(List<ContainerImage> images) {
        this.images.clear();
        if (images != null) {
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withImages(ContainerImage ... images) {
        this.images.clear();
        if (images != null) {
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> addNewImageLike(ContainerImage item) {
        return new ImagesNestedImpl(item);
    }

    @Override
    public NodeSystemInfo getNodeInfo() {
        return this.nodeInfo != null ? (NodeSystemInfo)this.nodeInfo.build() : null;
    }

    @Override
    public A withNodeInfo(NodeSystemInfo nodeInfo) {
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.add(this.nodeInfo);
        }
        return (A)this;
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo() {
        return new NodeInfoNestedImpl();
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNestedImpl(item);
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> editNodeInfo() {
        return this.withNewNodeInfoLike(this.getNodeInfo());
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatusFluentImpl that = (NodeStatusFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.allocatable != null ? !this.allocatable.equals(that.allocatable) : that.allocatable != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.daemonEndpoints != null ? !this.daemonEndpoints.equals(that.daemonEndpoints) : that.daemonEndpoints != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.nodeInfo != null ? !this.nodeInfo.equals(that.nodeInfo) : that.nodeInfo != null) {
            return false;
        }
        return !(this.phase != null ? !this.phase.equals(that.phase) : that.phase != null);
    }

    public class NodeInfoNestedImpl<N>
    extends NodeSystemInfoFluentImpl<NodeStatusFluent.NodeInfoNested<N>>
    implements NodeStatusFluent.NodeInfoNested<N> {
        private final NodeSystemInfoBuilder builder;

        NodeInfoNestedImpl(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        NodeInfoNestedImpl() {
            this.builder = new NodeSystemInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.withNodeInfo(this.builder.build());
        }

        @Override
        public N endNodeInfo() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ContainerImageFluentImpl<NodeStatusFluent.ImagesNested<N>>
    implements NodeStatusFluent.ImagesNested<N> {
        private final ContainerImageBuilder builder;

        ImagesNestedImpl() {
            this.builder = new ContainerImageBuilder(this);
        }

        ImagesNestedImpl(ContainerImage item) {
            this.builder = new ContainerImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.addToImages(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class DaemonEndpointsNestedImpl<N>
    extends NodeDaemonEndpointsFluentImpl<NodeStatusFluent.DaemonEndpointsNested<N>>
    implements NodeStatusFluent.DaemonEndpointsNested<N> {
        private final NodeDaemonEndpointsBuilder builder;

        DaemonEndpointsNestedImpl() {
            this.builder = new NodeDaemonEndpointsBuilder(this);
        }

        DaemonEndpointsNestedImpl(NodeDaemonEndpoints item) {
            this.builder = new NodeDaemonEndpointsBuilder(this, item);
        }

        @Override
        public N endDaemonEndpoints() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.withDaemonEndpoints(this.builder.build());
        }
    }

    public class ConditionsNestedImpl<N>
    extends NodeConditionFluentImpl<NodeStatusFluent.ConditionsNested<N>>
    implements NodeStatusFluent.ConditionsNested<N> {
        private final NodeConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new NodeConditionBuilder(this);
        }

        ConditionsNestedImpl(NodeCondition item) {
            this.builder = new NodeConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }

    public class AddressesNestedImpl<N>
    extends NodeAddressFluentImpl<NodeStatusFluent.AddressesNested<N>>
    implements NodeStatusFluent.AddressesNested<N> {
        private final NodeAddressBuilder builder;

        AddressesNestedImpl() {
            this.builder = new NodeAddressBuilder(this);
        }

        AddressesNestedImpl(NodeAddress item) {
            this.builder = new NodeAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.addToAddresses(this.builder.build());
        }

        @Override
        public N endAddresse() {
            return this.and();
        }
    }
}

