/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeSystemInfoBuilder
extends NodeSystemInfoFluentImpl<NodeSystemInfoBuilder>
implements VisitableBuilder<NodeSystemInfo, NodeSystemInfoBuilder> {
    NodeSystemInfoFluent<?> fluent;

    public NodeSystemInfoBuilder() {
        this(new NodeSystemInfo());
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent) {
        this(fluent, new NodeSystemInfo());
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent, NodeSystemInfo instance) {
        this.fluent = fluent;
        fluent.withBootID(instance.getBootID());
        fluent.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        fluent.withKernelVersion(instance.getKernelVersion());
        fluent.withKubeProxyVersion(instance.getKubeProxyVersion());
        fluent.withKubeletVersion(instance.getKubeletVersion());
        fluent.withMachineID(instance.getMachineID());
        fluent.withOsImage(instance.getOsImage());
        fluent.withSystemUUID(instance.getSystemUUID());
    }

    public NodeSystemInfoBuilder(NodeSystemInfo instance) {
        this.fluent = this;
        this.withBootID(instance.getBootID());
        this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        this.withKernelVersion(instance.getKernelVersion());
        this.withKubeProxyVersion(instance.getKubeProxyVersion());
        this.withKubeletVersion(instance.getKubeletVersion());
        this.withMachineID(instance.getMachineID());
        this.withOsImage(instance.getOsImage());
        this.withSystemUUID(instance.getSystemUUID());
    }

    @Override
    public NodeSystemInfo build() {
        NodeSystemInfo buildable = new NodeSystemInfo(this.fluent.getBootID(), this.fluent.getContainerRuntimeVersion(), this.fluent.getKernelVersion(), this.fluent.getKubeProxyVersion(), this.fluent.getKubeletVersion(), this.fluent.getMachineID(), this.fluent.getOsImage(), this.fluent.getSystemUUID());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSystemInfoBuilder that = (NodeSystemInfoBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

