/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ObjectReferenceBuilder
extends ObjectReferenceFluentImpl<ObjectReferenceBuilder>
implements VisitableBuilder<ObjectReference, ObjectReferenceBuilder> {
    ObjectReferenceFluent<?> fluent;

    public ObjectReferenceBuilder() {
        this(new ObjectReference());
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
        this(fluent, new ObjectReference());
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withFieldPath(instance.getFieldPath());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withUid(instance.getUid());
    }

    public ObjectReferenceBuilder(ObjectReference instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withFieldPath(instance.getFieldPath());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withUid(instance.getUid());
    }

    @Override
    public ObjectReference build() {
        ObjectReference buildable = new ObjectReference(this.fluent.getApiVersion(), this.fluent.getFieldPath(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getResourceVersion(), this.fluent.getUid());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectReferenceBuilder that = (ObjectReferenceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

