/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluent;
import java.util.ArrayList;
import java.util.List;

public class PersistentVolumeClaimListFluentImpl<A extends PersistentVolumeClaimListFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeClaimListFluent<A> {
    String apiVersion;
    List<VisitableBuilder<PersistentVolumeClaim, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;

    public PersistentVolumeClaimListFluentImpl() {
    }

    public PersistentVolumeClaimListFluentImpl(PersistentVolumeClaimList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(PersistentVolumeClaim ... items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(PersistentVolumeClaim ... items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<PersistentVolumeClaim> getItems() {
        return this.build(this.items);
    }

    @Override
    public A withItems(List<PersistentVolumeClaim> items) {
        this.items.clear();
        if (items != null) {
            for (PersistentVolumeClaim item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(PersistentVolumeClaim ... items) {
        this.items.clear();
        if (items != null) {
            for (PersistentVolumeClaim item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeClaimListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public PersistentVolumeClaimListFluent.ItemsNested<A> addNewItemLike(PersistentVolumeClaim item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeClaimListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PersistentVolumeClaimListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimListFluentImpl that = (PersistentVolumeClaimListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<PersistentVolumeClaimListFluent.MetadataNested<N>>
    implements PersistentVolumeClaimListFluent.MetadataNested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<PersistentVolumeClaimListFluent.ItemsNested<N>>
    implements PersistentVolumeClaimListFluent.ItemsNested<N> {
        private final PersistentVolumeClaimBuilder builder;

        ItemsNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        ItemsNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

