/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class PersistentVolumeClaimSpecFluentImpl<A extends PersistentVolumeClaimSpecFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeClaimSpecFluent<A> {
    List<String> accessModes = new ArrayList<String>();
    VisitableBuilder<ResourceRequirements, ?> resources;
    String volumeName;

    public PersistentVolumeClaimSpecFluentImpl() {
    }

    public PersistentVolumeClaimSpecFluentImpl(PersistentVolumeClaimSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withResources(instance.getResources());
        this.withVolumeName(instance.getVolumeName());
    }

    @Override
    public A addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null);
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<PersistentVolumeClaimSpecFluent.ResourcesNested<N>>
    implements PersistentVolumeClaimSpecFluent.ResourcesNested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }
}

