/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSource;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlexVolumeSource;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlockerVolumeSource;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeSpecFluent<A> {
    List<String> accessModes = new ArrayList<String>();
    VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    VisitableBuilder<AzureFileVolumeSource, ?> azureFile;
    Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    VisitableBuilder<CephFSVolumeSource, ?> cephfs;
    VisitableBuilder<CinderVolumeSource, ?> cinder;
    VisitableBuilder<ObjectReference, ?> claimRef;
    VisitableBuilder<FCVolumeSource, ?> fc;
    VisitableBuilder<FlexVolumeSource, ?> flexVolume;
    VisitableBuilder<FlockerVolumeSource, ?> flocker;
    VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;
    VisitableBuilder<HostPathVolumeSource, ?> hostPath;
    VisitableBuilder<ISCSIVolumeSource, ?> iscsi;
    VisitableBuilder<NFSVolumeSource, ?> nfs;
    String persistentVolumeReclaimPolicy;
    VisitableBuilder<RBDVolumeSource, ?> rbd;

    public PersistentVolumeSpecFluentImpl() {
    }

    public PersistentVolumeSpecFluentImpl(PersistentVolumeSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureFile(instance.getAzureFile());
        this.withCapacity(instance.getCapacity());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withClaimRef(instance.getClaimRef());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
        this.withRbd(instance.getRbd());
    }

    @Override
    public A addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    @Override
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    @Override
    public A withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    @Override
    public AzureFileVolumeSource getAzureFile() {
        return this.azureFile != null ? (AzureFileVolumeSource)this.azureFile.build() : null;
    }

    @Override
    public A withAzureFile(AzureFileVolumeSource azureFile) {
        if (azureFile != null) {
            this.azureFile = new AzureFileVolumeSourceBuilder(azureFile);
            this._visitables.add(this.azureFile);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile() {
        return new AzureFileNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item) {
        return new AzureFileNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile() {
        return this.withNewAzureFileLike(this.getAzureFile());
    }

    @Override
    public A withNewAzureFile(Boolean readOnly, String secretName, String shareName) {
        return this.withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (key != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (A)this;
    }

    @Override
    public CephFSVolumeSource getCephfs() {
        return this.cephfs != null ? (CephFSVolumeSource)this.cephfs.build() : null;
    }

    @Override
    public A withCephfs(CephFSVolumeSource cephfs) {
        if (cephfs != null) {
            this.cephfs = new CephFSVolumeSourceBuilder(cephfs);
            this._visitables.add(this.cephfs);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs() {
        return new CephfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item) {
        return new CephfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs() {
        return this.withNewCephfsLike(this.getCephfs());
    }

    @Override
    public CinderVolumeSource getCinder() {
        return this.cinder != null ? (CinderVolumeSource)this.cinder.build() : null;
    }

    @Override
    public A withCinder(CinderVolumeSource cinder) {
        if (cinder != null) {
            this.cinder = new CinderVolumeSourceBuilder(cinder);
            this._visitables.add(this.cinder);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder() {
        return new CinderNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item) {
        return new CinderNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> editCinder() {
        return this.withNewCinderLike(this.getCinder());
    }

    @Override
    public A withNewCinder(String fsType, Boolean readOnly, String volumeID) {
        return this.withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    @Override
    public ObjectReference getClaimRef() {
        return this.claimRef != null ? (ObjectReference)this.claimRef.build() : null;
    }

    @Override
    public A withClaimRef(ObjectReference claimRef) {
        if (claimRef != null) {
            this.claimRef = new ObjectReferenceBuilder(claimRef);
            this._visitables.add(this.claimRef);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef() {
        return new ClaimRefNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item) {
        return new ClaimRefNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef());
    }

    @Override
    public FCVolumeSource getFc() {
        return this.fc != null ? (FCVolumeSource)this.fc.build() : null;
    }

    @Override
    public A withFc(FCVolumeSource fc) {
        if (fc != null) {
            this.fc = new FCVolumeSourceBuilder(fc);
            this._visitables.add(this.fc);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> withNewFc() {
        return new FcNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item) {
        return new FcNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> editFc() {
        return this.withNewFcLike(this.getFc());
    }

    @Override
    public FlexVolumeSource getFlexVolume() {
        return this.flexVolume != null ? (FlexVolumeSource)this.flexVolume.build() : null;
    }

    @Override
    public A withFlexVolume(FlexVolumeSource flexVolume) {
        if (flexVolume != null) {
            this.flexVolume = new FlexVolumeSourceBuilder(flexVolume);
            this._visitables.add(this.flexVolume);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume() {
        return new FlexVolumeNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item) {
        return new FlexVolumeNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume() {
        return this.withNewFlexVolumeLike(this.getFlexVolume());
    }

    @Override
    public FlockerVolumeSource getFlocker() {
        return this.flocker != null ? (FlockerVolumeSource)this.flocker.build() : null;
    }

    @Override
    public A withFlocker(FlockerVolumeSource flocker) {
        if (flocker != null) {
            this.flocker = new FlockerVolumeSourceBuilder(flocker);
            this._visitables.add(this.flocker);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker() {
        return new FlockerNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item) {
        return new FlockerNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker() {
        return this.withNewFlockerLike(this.getFlocker());
    }

    @Override
    public A withNewFlocker(String datasetName) {
        return this.withFlocker(new FlockerVolumeSource(datasetName));
    }

    @Override
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    @Override
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk() {
        return new GcePersistentDiskNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    @Override
    public A withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    @Override
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    @Override
    public A withGlusterfs(GlusterfsVolumeSource glusterfs) {
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs() {
        return new GlusterfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    @Override
    public A withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    @Override
    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    @Override
    public A withHostPath(HostPathVolumeSource hostPath) {
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath() {
        return new HostPathNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    @Override
    public A withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    @Override
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? (ISCSIVolumeSource)this.iscsi.build() : null;
    }

    @Override
    public A withIscsi(ISCSIVolumeSource iscsi) {
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi() {
        return new IscsiNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    @Override
    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    @Override
    public A withNfs(NFSVolumeSource nfs) {
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs() {
        return new NfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    @Override
    public A withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    @Override
    public String getPersistentVolumeReclaimPolicy() {
        return this.persistentVolumeReclaimPolicy;
    }

    @Override
    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        return (A)this;
    }

    @Override
    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    @Override
    public A withRbd(RBDVolumeSource rbd) {
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (A)this;
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd() {
        return new RbdNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.awsElasticBlockStore != null ? !this.awsElasticBlockStore.equals(that.awsElasticBlockStore) : that.awsElasticBlockStore != null) {
            return false;
        }
        if (this.azureFile != null ? !this.azureFile.equals(that.azureFile) : that.azureFile != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.cephfs != null ? !this.cephfs.equals(that.cephfs) : that.cephfs != null) {
            return false;
        }
        if (this.cinder != null ? !this.cinder.equals(that.cinder) : that.cinder != null) {
            return false;
        }
        if (this.claimRef != null ? !this.claimRef.equals(that.claimRef) : that.claimRef != null) {
            return false;
        }
        if (this.fc != null ? !this.fc.equals(that.fc) : that.fc != null) {
            return false;
        }
        if (this.flexVolume != null ? !this.flexVolume.equals(that.flexVolume) : that.flexVolume != null) {
            return false;
        }
        if (this.flocker != null ? !this.flocker.equals(that.flocker) : that.flocker != null) {
            return false;
        }
        if (this.gcePersistentDisk != null ? !this.gcePersistentDisk.equals(that.gcePersistentDisk) : that.gcePersistentDisk != null) {
            return false;
        }
        if (this.glusterfs != null ? !this.glusterfs.equals(that.glusterfs) : that.glusterfs != null) {
            return false;
        }
        if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) {
            return false;
        }
        if (this.iscsi != null ? !this.iscsi.equals(that.iscsi) : that.iscsi != null) {
            return false;
        }
        if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) {
            return false;
        }
        if (this.persistentVolumeReclaimPolicy != null ? !this.persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) : that.persistentVolumeReclaimPolicy != null) {
            return false;
        }
        return !(this.rbd != null ? !this.rbd.equals(that.rbd) : that.rbd != null);
    }

    public class RbdNestedImpl<N>
    extends RBDVolumeSourceFluentImpl<PersistentVolumeSpecFluent.RbdNested<N>>
    implements PersistentVolumeSpecFluent.RbdNested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNestedImpl() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        RbdNestedImpl(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withRbd(this.builder.build());
        }

        @Override
        public N endRbd() {
            return this.and();
        }
    }

    public class NfsNestedImpl<N>
    extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.NfsNested<N>>
    implements PersistentVolumeSpecFluent.NfsNested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNestedImpl(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        NfsNestedImpl() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        @Override
        public N endNfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withNfs(this.builder.build());
        }
    }

    public class IscsiNestedImpl<N>
    extends ISCSIVolumeSourceFluentImpl<PersistentVolumeSpecFluent.IscsiNested<N>>
    implements PersistentVolumeSpecFluent.IscsiNested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNestedImpl(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        IscsiNestedImpl() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withIscsi(this.builder.build());
        }

        @Override
        public N endIscsi() {
            return this.and();
        }
    }

    public class HostPathNestedImpl<N>
    extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluent.HostPathNested<N>>
    implements PersistentVolumeSpecFluent.HostPathNested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNestedImpl() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        HostPathNestedImpl(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withHostPath(this.builder.build());
        }

        @Override
        public N endHostPath() {
            return this.and();
        }
    }

    public class GlusterfsNestedImpl<N>
    extends GlusterfsVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GlusterfsNested<N>>
    implements PersistentVolumeSpecFluent.GlusterfsNested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNestedImpl() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        GlusterfsNestedImpl(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGlusterfs(this.builder.build());
        }

        @Override
        public N endGlusterfs() {
            return this.and();
        }
    }

    public class GcePersistentDiskNestedImpl<N>
    extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>>
    implements PersistentVolumeSpecFluent.GcePersistentDiskNested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNestedImpl() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        @Override
        public N endGcePersistentDisk() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(this.builder.build());
        }
    }

    public class FlockerNestedImpl<N>
    extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlockerNested<N>>
    implements PersistentVolumeSpecFluent.FlockerNested<N> {
        private final FlockerVolumeSourceBuilder builder;

        FlockerNestedImpl() {
            this.builder = new FlockerVolumeSourceBuilder(this);
        }

        FlockerNestedImpl(FlockerVolumeSource item) {
            this.builder = new FlockerVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFlocker(this.builder.build());
        }

        @Override
        public N endFlocker() {
            return this.and();
        }
    }

    public class FlexVolumeNestedImpl<N>
    extends FlexVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlexVolumeNested<N>>
    implements PersistentVolumeSpecFluent.FlexVolumeNested<N> {
        private final FlexVolumeSourceBuilder builder;

        FlexVolumeNestedImpl() {
            this.builder = new FlexVolumeSourceBuilder(this);
        }

        FlexVolumeNestedImpl(FlexVolumeSource item) {
            this.builder = new FlexVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFlexVolume(this.builder.build());
        }

        @Override
        public N endFlexVolume() {
            return this.and();
        }
    }

    public class FcNestedImpl<N>
    extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FcNested<N>>
    implements PersistentVolumeSpecFluent.FcNested<N> {
        private final FCVolumeSourceBuilder builder;

        FcNestedImpl() {
            this.builder = new FCVolumeSourceBuilder(this);
        }

        FcNestedImpl(FCVolumeSource item) {
            this.builder = new FCVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFc(this.builder.build());
        }

        @Override
        public N endFc() {
            return this.and();
        }
    }

    public class ClaimRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluent.ClaimRefNested<N>>
    implements PersistentVolumeSpecFluent.ClaimRefNested<N> {
        private final ObjectReferenceBuilder builder;

        ClaimRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        ClaimRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withClaimRef(this.builder.build());
        }

        @Override
        public N endClaimRef() {
            return this.and();
        }
    }

    public class CinderNestedImpl<N>
    extends CinderVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CinderNested<N>>
    implements PersistentVolumeSpecFluent.CinderNested<N> {
        private final CinderVolumeSourceBuilder builder;

        CinderNestedImpl() {
            this.builder = new CinderVolumeSourceBuilder(this);
        }

        CinderNestedImpl(CinderVolumeSource item) {
            this.builder = new CinderVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCinder(this.builder.build());
        }

        @Override
        public N endCinder() {
            return this.and();
        }
    }

    public class CephfsNestedImpl<N>
    extends CephFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CephfsNested<N>>
    implements PersistentVolumeSpecFluent.CephfsNested<N> {
        private final CephFSVolumeSourceBuilder builder;

        CephfsNestedImpl() {
            this.builder = new CephFSVolumeSourceBuilder(this);
        }

        CephfsNestedImpl(CephFSVolumeSource item) {
            this.builder = new CephFSVolumeSourceBuilder(this, item);
        }

        @Override
        public N endCephfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCephfs(this.builder.build());
        }
    }

    public class AzureFileNestedImpl<N>
    extends AzureFileVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureFileNested<N>>
    implements PersistentVolumeSpecFluent.AzureFileNested<N> {
        private final AzureFileVolumeSourceBuilder builder;

        AzureFileNestedImpl(AzureFileVolumeSource item) {
            this.builder = new AzureFileVolumeSourceBuilder(this, item);
        }

        AzureFileNestedImpl() {
            this.builder = new AzureFileVolumeSourceBuilder(this);
        }

        @Override
        public N endAzureFile() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAzureFile(this.builder.build());
        }
    }

    public class AwsElasticBlockStoreNestedImpl<N>
    extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>>
    implements PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNestedImpl() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        @Override
        public N endAwsElasticBlockStore() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(this.builder.build());
        }
    }
}

