/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import io.fabric8.kubernetes.api.model.PodStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodStatusBuilder
extends PodStatusFluentImpl<PodStatusBuilder>
implements VisitableBuilder<PodStatus, PodStatusBuilder> {
    PodStatusFluent<?> fluent;

    public PodStatusBuilder() {
        this(new PodStatus());
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent) {
        this(fluent, new PodStatus());
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, PodStatus instance) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withContainerStatuses(instance.getContainerStatuses());
        fluent.withHostIP(instance.getHostIP());
        fluent.withMessage(instance.getMessage());
        fluent.withPhase(instance.getPhase());
        fluent.withPodIP(instance.getPodIP());
        fluent.withReason(instance.getReason());
        fluent.withStartTime(instance.getStartTime());
    }

    public PodStatusBuilder(PodStatus instance) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withMessage(instance.getMessage());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public PodStatus build() {
        PodStatus buildable = new PodStatus(this.fluent.getConditions(), this.fluent.getContainerStatuses(), this.fluent.getHostIP(), this.fluent.getMessage(), this.fluent.getPhase(), this.fluent.getPodIP(), this.fluent.getReason(), this.fluent.getStartTime());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodStatusBuilder that = (PodStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

