/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.PodTemplateBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateList;
import io.fabric8.kubernetes.api.model.PodTemplateListFluent;
import java.util.ArrayList;
import java.util.List;

public class PodTemplateListFluentImpl<A extends PodTemplateListFluent<A>>
extends BaseFluent<A>
implements PodTemplateListFluent<A> {
    String apiVersion;
    List<VisitableBuilder<PodTemplate, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;

    public PodTemplateListFluentImpl() {
    }

    public PodTemplateListFluentImpl(PodTemplateList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(PodTemplate ... items) {
        for (PodTemplate item : items) {
            PodTemplateBuilder builder = new PodTemplateBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(PodTemplate ... items) {
        for (PodTemplate item : items) {
            PodTemplateBuilder builder = new PodTemplateBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<PodTemplate> getItems() {
        return this.build(this.items);
    }

    @Override
    public A withItems(List<PodTemplate> items) {
        this.items.clear();
        if (items != null) {
            for (PodTemplate item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(PodTemplate ... items) {
        this.items.clear();
        if (items != null) {
            for (PodTemplate item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public PodTemplateListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public PodTemplateListFluent.ItemsNested<A> addNewItemLike(PodTemplate item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PodTemplateListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodTemplateListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodTemplateListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodTemplateListFluentImpl that = (PodTemplateListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<PodTemplateListFluent.MetadataNested<N>>
    implements PodTemplateListFluent.MetadataNested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodTemplateListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends PodTemplateFluentImpl<PodTemplateListFluent.ItemsNested<N>>
    implements PodTemplateListFluent.ItemsNested<N> {
        private final PodTemplateBuilder builder;

        ItemsNestedImpl() {
            this.builder = new PodTemplateBuilder(this);
        }

        ItemsNestedImpl(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodTemplateListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

