/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Preferences;
import io.fabric8.kubernetes.api.model.PreferencesFluent;
import io.fabric8.kubernetes.api.model.PreferencesFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PreferencesBuilder
extends PreferencesFluentImpl<PreferencesBuilder>
implements VisitableBuilder<Preferences, PreferencesBuilder> {
    PreferencesFluent<?> fluent;

    public PreferencesBuilder() {
        this(new Preferences());
    }

    public PreferencesBuilder(PreferencesFluent<?> fluent) {
        this(fluent, new Preferences());
    }

    public PreferencesBuilder(PreferencesFluent<?> fluent, Preferences instance) {
        this.fluent = fluent;
        fluent.withColors(instance.getColors());
        fluent.withExtensions(instance.getExtensions());
    }

    public PreferencesBuilder(Preferences instance) {
        this.fluent = this;
        this.withColors(instance.getColors());
        this.withExtensions(instance.getExtensions());
    }

    @Override
    public Preferences build() {
        Preferences buildable = new Preferences(this.fluent.isColors(), this.fluent.getExtensions());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreferencesBuilder that = (PreferencesBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

