/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.ProbeFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ProbeBuilder
extends ProbeFluentImpl<ProbeBuilder>
implements VisitableBuilder<Probe, ProbeBuilder> {
    ProbeFluent<?> fluent;

    public ProbeBuilder() {
        this(new Probe());
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, new Probe());
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withFailureThreshold(instance.getFailureThreshold());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        fluent.withSuccessThreshold(instance.getSuccessThreshold());
        fluent.withTcpSocket(instance.getTcpSocket());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
    }

    public ProbeBuilder(Probe instance) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withFailureThreshold(instance.getFailureThreshold());
        this.withHttpGet(instance.getHttpGet());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withPeriodSeconds(instance.getPeriodSeconds());
        this.withSuccessThreshold(instance.getSuccessThreshold());
        this.withTcpSocket(instance.getTcpSocket());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
    }

    @Override
    public Probe build() {
        Probe buildable = new Probe(this.fluent.getExec(), this.fluent.getFailureThreshold(), this.fluent.getHttpGet(), this.fluent.getInitialDelaySeconds(), this.fluent.getPeriodSeconds(), this.fluent.getSuccessThreshold(), this.fluent.getTcpSocket(), this.fluent.getTimeoutSeconds());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeBuilder that = (ProbeBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

