/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableQuantity;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityFluent;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class QuantityBuilder
extends QuantityFluentImpl<QuantityBuilder>
implements VisitableBuilder<Quantity, QuantityBuilder> {
    QuantityFluent<?> fluent;

    public QuantityBuilder() {
        this(new Quantity());
    }

    public QuantityBuilder(QuantityFluent<?> fluent) {
        this(fluent, new Quantity());
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance) {
        this.fluent = fluent;
        fluent.withAmount(instance.getAmount());
        fluent.withFormat(instance.getFormat());
    }

    public QuantityBuilder(Quantity instance) {
        this.fluent = this;
        this.withAmount(instance.getAmount());
        this.withFormat(instance.getFormat());
    }

    @Override
    public EditableQuantity build() {
        EditableQuantity buildable = new EditableQuantity(this.fluent.getAmount());
        buildable.setFormat(this.fluent.getFormat());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuantityBuilder that = (QuantityBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

