/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ReplicationControllerSpecBuilder
extends ReplicationControllerSpecFluentImpl<ReplicationControllerSpecBuilder>
implements VisitableBuilder<ReplicationControllerSpec, ReplicationControllerSpecBuilder> {
    ReplicationControllerSpecFluent<?> fluent;

    public ReplicationControllerSpecBuilder() {
        this(new ReplicationControllerSpec());
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent) {
        this(fluent, new ReplicationControllerSpec());
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent, ReplicationControllerSpec instance) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public ReplicationControllerSpec build() {
        ReplicationControllerSpec buildable = new ReplicationControllerSpec(this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getTemplate());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerSpecBuilder that = (ReplicationControllerSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

