/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ResourceQuotaSpecBuilder
extends ResourceQuotaSpecFluentImpl<ResourceQuotaSpecBuilder>
implements VisitableBuilder<ResourceQuotaSpec, ResourceQuotaSpecBuilder> {
    ResourceQuotaSpecFluent<?> fluent;

    public ResourceQuotaSpecBuilder() {
        this(new ResourceQuotaSpec());
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent) {
        this(fluent, new ResourceQuotaSpec());
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent, ResourceQuotaSpec instance) {
        this.fluent = fluent;
        fluent.withHard(instance.getHard());
        fluent.withScopes(instance.getScopes());
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance) {
        this.fluent = this;
        this.withHard(instance.getHard());
        this.withScopes(instance.getScopes());
    }

    @Override
    public ResourceQuotaSpec build() {
        ResourceQuotaSpec buildable = new ResourceQuotaSpec(this.fluent.getHard(), this.fluent.getScopes());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaSpecBuilder that = (ResourceQuotaSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

