/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SELinuxOptionsBuilder
extends SELinuxOptionsFluentImpl<SELinuxOptionsBuilder>
implements VisitableBuilder<SELinuxOptions, SELinuxOptionsBuilder> {
    SELinuxOptionsFluent<?> fluent;

    public SELinuxOptionsBuilder() {
        this(new SELinuxOptions());
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent) {
        this(fluent, new SELinuxOptions());
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent, SELinuxOptions instance) {
        this.fluent = fluent;
        fluent.withLevel(instance.getLevel());
        fluent.withRole(instance.getRole());
        fluent.withType(instance.getType());
        fluent.withUser(instance.getUser());
    }

    public SELinuxOptionsBuilder(SELinuxOptions instance) {
        this.fluent = this;
        this.withLevel(instance.getLevel());
        this.withRole(instance.getRole());
        this.withType(instance.getType());
        this.withUser(instance.getUser());
    }

    @Override
    public SELinuxOptions build() {
        SELinuxOptions buildable = new SELinuxOptions(this.fluent.getLevel(), this.fluent.getRole(), this.fluent.getType(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SELinuxOptionsBuilder that = (SELinuxOptionsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

