/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.SecurityContextFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecurityContextBuilder
extends SecurityContextFluentImpl<SecurityContextBuilder>
implements VisitableBuilder<SecurityContext, SecurityContextBuilder> {
    SecurityContextFluent<?> fluent;

    public SecurityContextBuilder() {
        this(new SecurityContext());
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
        this(fluent, new SecurityContext());
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, SecurityContext instance) {
        this.fluent = fluent;
        fluent.withCapabilities(instance.getCapabilities());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
    }

    public SecurityContextBuilder(SecurityContext instance) {
        this.fluent = this;
        this.withCapabilities(instance.getCapabilities());
        this.withPrivileged(instance.getPrivileged());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
    }

    @Override
    public SecurityContext build() {
        SecurityContext buildable = new SecurityContext(this.fluent.getCapabilities(), this.fluent.isPrivileged(), this.fluent.isReadOnlyRootFilesystem(), this.fluent.isRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextBuilder that = (SecurityContextBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

