/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceAccountListFluent;
import java.util.ArrayList;
import java.util.List;

public class ServiceAccountListFluentImpl<A extends ServiceAccountListFluent<A>>
extends BaseFluent<A>
implements ServiceAccountListFluent<A> {
    String apiVersion;
    List<VisitableBuilder<ServiceAccount, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;

    public ServiceAccountListFluentImpl() {
    }

    public ServiceAccountListFluentImpl(ServiceAccountList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(ServiceAccount ... items) {
        for (ServiceAccount item : items) {
            ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ServiceAccount ... items) {
        for (ServiceAccount item : items) {
            ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ServiceAccount> getItems() {
        return this.build(this.items);
    }

    @Override
    public A withItems(List<ServiceAccount> items) {
        this.items.clear();
        if (items != null) {
            for (ServiceAccount item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(ServiceAccount ... items) {
        this.items.clear();
        if (items != null) {
            for (ServiceAccount item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public ServiceAccountListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ServiceAccountListFluent.ItemsNested<A> addNewItemLike(ServiceAccount item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ServiceAccountListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServiceAccountListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServiceAccountListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountListFluentImpl that = (ServiceAccountListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<ServiceAccountListFluent.MetadataNested<N>>
    implements ServiceAccountListFluent.MetadataNested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServiceAccountListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends ServiceAccountFluentImpl<ServiceAccountListFluent.ItemsNested<N>>
    implements ServiceAccountListFluent.ItemsNested<N> {
        private final ServiceAccountBuilder builder;

        ItemsNestedImpl() {
            this.builder = new ServiceAccountBuilder(this);
        }

        ItemsNestedImpl(ServiceAccount item) {
            this.builder = new ServiceAccountBuilder(this, item);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ServiceAccountListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

