/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServicePortFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>>
extends BaseFluent<A>
implements ServiceSpecFluent<A> {
    String clusterIP;
    List<String> deprecatedPublicIPs = new ArrayList<String>();
    List<String> externalIPs = new ArrayList<String>();
    String loadBalancerIP;
    String portalIP;
    List<VisitableBuilder<ServicePort, ?>> ports = new ArrayList();
    Map<String, String> selector = new HashMap<String, String>();
    String sessionAffinity;
    String type;

    public ServiceSpecFluentImpl() {
    }

    public ServiceSpecFluentImpl(ServiceSpec instance) {
        this.withClusterIP(instance.getClusterIP());
        this.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs());
        this.withExternalIPs(instance.getExternalIPs());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withPortalIP(instance.getPortalIP());
        this.withPorts(instance.getPorts());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withType(instance.getType());
    }

    @Override
    public String getClusterIP() {
        return this.clusterIP;
    }

    @Override
    public A withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (A)this;
    }

    @Override
    public A addToDeprecatedPublicIPs(String ... items) {
        for (String item : items) {
            this.deprecatedPublicIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeprecatedPublicIPs(String ... items) {
        for (String item : items) {
            this.deprecatedPublicIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDeprecatedPublicIPs() {
        return this.deprecatedPublicIPs;
    }

    @Override
    public A withDeprecatedPublicIPs(List<String> deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDeprecatedPublicIPs(String ... deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToExternalIPs(String ... items) {
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalIPs(String ... items) {
        for (String item : items) {
            this.externalIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    @Override
    public A withExternalIPs(List<String> externalIPs) {
        this.externalIPs.clear();
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExternalIPs(String ... externalIPs) {
        this.externalIPs.clear();
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    @Override
    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)this;
    }

    @Override
    public String getPortalIP() {
        return this.portalIP;
    }

    @Override
    public A withPortalIP(String portalIP) {
        this.portalIP = portalIP;
        return (A)this;
    }

    @Override
    public A addToPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ServicePort> getPorts() {
        return this.build(this.ports);
    }

    @Override
    public A withPorts(List<ServicePort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPorts(ServicePort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item) {
        return new PortsNestedImpl(item);
    }

    @Override
    public A addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (A)this;
    }

    @Override
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    @Override
    public A withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (A)this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecFluentImpl that = (ServiceSpecFluentImpl)o;
        if (this.clusterIP != null ? !this.clusterIP.equals(that.clusterIP) : that.clusterIP != null) {
            return false;
        }
        if (this.deprecatedPublicIPs != null ? !this.deprecatedPublicIPs.equals(that.deprecatedPublicIPs) : that.deprecatedPublicIPs != null) {
            return false;
        }
        if (this.externalIPs != null ? !this.externalIPs.equals(that.externalIPs) : that.externalIPs != null) {
            return false;
        }
        if (this.loadBalancerIP != null ? !this.loadBalancerIP.equals(that.loadBalancerIP) : that.loadBalancerIP != null) {
            return false;
        }
        if (this.portalIP != null ? !this.portalIP.equals(that.portalIP) : that.portalIP != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.sessionAffinity != null ? !this.sessionAffinity.equals(that.sessionAffinity) : that.sessionAffinity != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class PortsNestedImpl<N>
    extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>>
    implements ServiceSpecFluent.PortsNested<N> {
        private final ServicePortBuilder builder;

        PortsNestedImpl() {
            this.builder = new ServicePortBuilder(this);
        }

        PortsNestedImpl(ServicePort item) {
            this.builder = new ServicePortBuilder(this, item);
        }

        @Override
        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.addToPorts(this.builder.build());
        }
    }
}

